package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPipelineExecutionsResponse(
    pipelineExecutionSummaries: Optional[
      Iterable[zio.aws.codepipeline.model.PipelineExecutionSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse = {
    import ListPipelineExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse
      .builder()
      .optionallyWith(
        pipelineExecutionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineExecutionSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly =
    zio.aws.codepipeline.model.ListPipelineExecutionsResponse
      .wrap(buildAwsValue())
}
object ListPipelineExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListPipelineExecutionsResponse =
      zio.aws.codepipeline.model.ListPipelineExecutionsResponse(
        pipelineExecutionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pipelineExecutionSummaries: Optional[
      List[zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getPipelineExecutionSummaries: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pipelineExecutionSummaries",
      pipelineExecutionSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse
  ) extends zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly {
    override val pipelineExecutionSummaries: Optional[
      List[zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineExecutionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.PipelineExecutionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse
  ): zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
