package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codepipeline.model.primitives.{
  WebhookArn,
  WebhookUrl,
  WebhookErrorMessage,
  WebhookLastTriggered,
  WebhookErrorCode
}
import scala.jdk.CollectionConverters._
final case class ListWebhookItem(
    definition: zio.aws.codepipeline.model.WebhookDefinition,
    url: WebhookUrl,
    errorMessage: Optional[WebhookErrorMessage] = Optional.Absent,
    errorCode: Optional[WebhookErrorCode] = Optional.Absent,
    lastTriggered: Optional[WebhookLastTriggered] = Optional.Absent,
    arn: Optional[WebhookArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codepipeline.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListWebhookItem = {
    import ListWebhookItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListWebhookItem
      .builder()
      .definition(definition.buildAwsValue())
      .url(WebhookUrl.unwrap(url): java.lang.String)
      .optionallyWith(
        errorMessage.map(value =>
          WebhookErrorMessage.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        errorCode.map(value => WebhookErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        lastTriggered.map(value => WebhookLastTriggered.unwrap(value): Instant)
      )(_.lastTriggered)
      .optionallyWith(
        arn.map(value => WebhookArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListWebhookItem.ReadOnly =
    zio.aws.codepipeline.model.ListWebhookItem.wrap(buildAwsValue())
}
object ListWebhookItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListWebhookItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListWebhookItem =
      zio.aws.codepipeline.model.ListWebhookItem(
        definition.asEditable,
        url,
        errorMessage.map(value => value),
        errorCode.map(value => value),
        lastTriggered.map(value => value),
        arn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def definition: zio.aws.codepipeline.model.WebhookDefinition.ReadOnly
    def url: WebhookUrl
    def errorMessage: Optional[WebhookErrorMessage]
    def errorCode: Optional[WebhookErrorCode]
    def lastTriggered: Optional[WebhookLastTriggered]
    def arn: Optional[WebhookArn]
    def tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]]
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.WebhookDefinition.ReadOnly
    ] = ZIO.succeed(definition)
    def getUrl: ZIO[Any, Nothing, WebhookUrl] = ZIO.succeed(url)
    def getErrorMessage: ZIO[Any, AwsError, WebhookErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCode: ZIO[Any, AwsError, WebhookErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getLastTriggered: ZIO[Any, AwsError, WebhookLastTriggered] =
      AwsError.unwrapOptionField("lastTriggered", lastTriggered)
    def getArn: ZIO[Any, AwsError, WebhookArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListWebhookItem
  ) extends zio.aws.codepipeline.model.ListWebhookItem.ReadOnly {
    override val definition
        : zio.aws.codepipeline.model.WebhookDefinition.ReadOnly =
      zio.aws.codepipeline.model.WebhookDefinition.wrap(impl.definition())
    override val url: WebhookUrl =
      zio.aws.codepipeline.model.primitives.WebhookUrl(impl.url())
    override val errorMessage: Optional[WebhookErrorMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value =>
          zio.aws.codepipeline.model.primitives.WebhookErrorMessage(value)
        )
    override val errorCode: Optional[WebhookErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value =>
        zio.aws.codepipeline.model.primitives.WebhookErrorCode(value)
      )
    override val lastTriggered: Optional[WebhookLastTriggered] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastTriggered())
        .map(value =>
          zio.aws.codepipeline.model.primitives.WebhookLastTriggered(value)
        )
    override val arn: Optional[WebhookArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codepipeline.model.primitives.WebhookArn(value))
    override val tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListWebhookItem
  ): zio.aws.codepipeline.model.ListWebhookItem.ReadOnly = new Wrapper(impl)
}
