package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PipelineExecutionId,
  PipelineArn,
  PipelineName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PipelineContext(
    pipelineName: Optional[PipelineName] = Optional.Absent,
    stage: Optional[zio.aws.codepipeline.model.StageContext] = Optional.Absent,
    action: Optional[zio.aws.codepipeline.model.ActionContext] =
      Optional.Absent,
    pipelineArn: Optional[PipelineArn] = Optional.Absent,
    pipelineExecutionId: Optional[PipelineExecutionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineContext = {
    import PipelineContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineContext
      .builder()
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(stage.map(value => value.buildAwsValue()))(_.stage)
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineContext.ReadOnly =
    zio.aws.codepipeline.model.PipelineContext.wrap(buildAwsValue())
}
object PipelineContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineContext =
      zio.aws.codepipeline.model.PipelineContext(
        pipelineName.map(value => value),
        stage.map(value => value.asEditable),
        action.map(value => value.asEditable),
        pipelineArn.map(value => value),
        pipelineExecutionId.map(value => value)
      )
    def pipelineName: Optional[PipelineName]
    def stage: Optional[zio.aws.codepipeline.model.StageContext.ReadOnly]
    def action: Optional[zio.aws.codepipeline.model.ActionContext.ReadOnly]
    def pipelineArn: Optional[PipelineArn]
    def pipelineExecutionId: Optional[PipelineExecutionId]
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getStage
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.StageContext.ReadOnly] =
      AwsError.unwrapOptionField("stage", stage)
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionContext.ReadOnly
    ] = AwsError.unwrapOptionField("action", action)
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineContext
  ) extends zio.aws.codepipeline.model.PipelineContext.ReadOnly {
    override val pipelineName: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineName(value))
    override val stage
        : Optional[zio.aws.codepipeline.model.StageContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.codepipeline.model.StageContext.wrap(value))
    override val action
        : Optional[zio.aws.codepipeline.model.ActionContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.codepipeline.model.ActionContext.wrap(value))
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineArn(value))
    override val pipelineExecutionId: Optional[PipelineExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineContext
  ): zio.aws.codepipeline.model.PipelineContext.ReadOnly = new Wrapper(impl)
}
