package zio.aws.dax
import zio.aws.dax.model.DeleteSubnetGroupResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.dax.{
  DaxAsyncClientBuilder,
  DaxAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.dax.model.{
  DeleteSubnetGroupRequest,
  ParameterGroup,
  DescribeEventsResponse,
  UpdateClusterRequest,
  DeleteParameterGroupResponse,
  DescribeSubnetGroupsRequest,
  Cluster,
  DescribeSubnetGroupsResponse,
  DescribeParametersResponse,
  UpdateParameterGroupResponse,
  ListTagsRequest,
  RebootNodeRequest,
  UpdateSubnetGroupResponse,
  CreateSubnetGroupResponse,
  DescribeEventsRequest,
  Tag,
  UpdateParameterGroupRequest,
  CreateParameterGroupRequest,
  SubnetGroup,
  DecreaseReplicationFactorRequest,
  CreateClusterRequest,
  UpdateSubnetGroupRequest,
  UntagResourceResponse,
  CreateClusterResponse,
  DeleteClusterRequest,
  CreateSubnetGroupRequest,
  IncreaseReplicationFactorRequest,
  DescribeClustersResponse,
  DescribeDefaultParametersRequest,
  DeleteSubnetGroupResponse,
  RebootNodeResponse,
  UntagResourceRequest,
  Event,
  DeleteClusterResponse,
  DeleteParameterGroupRequest,
  IncreaseReplicationFactorResponse,
  TagResourceResponse,
  Parameter,
  DescribeParametersRequest,
  CreateParameterGroupResponse,
  DescribeParameterGroupsResponse,
  DescribeParameterGroupsRequest,
  DescribeClustersRequest,
  TagResourceRequest,
  ListTagsResponse,
  DescribeDefaultParametersResponse,
  DecreaseReplicationFactorResponse,
  UpdateClusterResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Dax extends AspectSupport[Dax] {
  val api: DaxAsyncClient
  def describeClusters(
      request: zio.aws.dax.model.DescribeClustersRequest
  ): ZStream[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly]
  def describeClustersPaginated(
      request: zio.aws.dax.model.DescribeClustersRequest
  ): IO[AwsError, zio.aws.dax.model.DescribeClustersResponse.ReadOnly]
  def increaseReplicationFactor(
      request: zio.aws.dax.model.IncreaseReplicationFactorRequest
  ): IO[AwsError, zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly]
  def describeParameterGroups(
      request: zio.aws.dax.model.DescribeParameterGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.dax.model.ParameterGroup.ReadOnly]
  def describeParameterGroupsPaginated(
      request: zio.aws.dax.model.DescribeParameterGroupsRequest
  ): IO[AwsError, zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly]
  def rebootNode(
      request: zio.aws.dax.model.RebootNodeRequest
  ): IO[AwsError, zio.aws.dax.model.RebootNodeResponse.ReadOnly]
  def listTags(
      request: zio.aws.dax.model.ListTagsRequest
  ): ZStream[Any, AwsError, zio.aws.dax.model.Tag.ReadOnly]
  def listTagsPaginated(
      request: zio.aws.dax.model.ListTagsRequest
  ): IO[AwsError, zio.aws.dax.model.ListTagsResponse.ReadOnly]
  def describeDefaultParameters(
      request: zio.aws.dax.model.DescribeDefaultParametersRequest
  ): ZStream[Any, AwsError, zio.aws.dax.model.Parameter.ReadOnly]
  def describeDefaultParametersPaginated(
      request: zio.aws.dax.model.DescribeDefaultParametersRequest
  ): IO[AwsError, zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly]
  def describeParameters(
      request: zio.aws.dax.model.DescribeParametersRequest
  ): ZStream[Any, AwsError, zio.aws.dax.model.Parameter.ReadOnly]
  def describeParametersPaginated(
      request: zio.aws.dax.model.DescribeParametersRequest
  ): IO[AwsError, zio.aws.dax.model.DescribeParametersResponse.ReadOnly]
  def decreaseReplicationFactor(
      request: zio.aws.dax.model.DecreaseReplicationFactorRequest
  ): IO[AwsError, zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly]
  def createCluster(
      request: zio.aws.dax.model.CreateClusterRequest
  ): IO[AwsError, zio.aws.dax.model.CreateClusterResponse.ReadOnly]
  def deleteCluster(
      request: zio.aws.dax.model.DeleteClusterRequest
  ): IO[AwsError, zio.aws.dax.model.DeleteClusterResponse.ReadOnly]
  def updateCluster(
      request: zio.aws.dax.model.UpdateClusterRequest
  ): IO[AwsError, zio.aws.dax.model.UpdateClusterResponse.ReadOnly]
  def updateParameterGroup(
      request: zio.aws.dax.model.UpdateParameterGroupRequest
  ): IO[AwsError, zio.aws.dax.model.UpdateParameterGroupResponse.ReadOnly]
  def untagResource(
      request: zio.aws.dax.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.dax.model.UntagResourceResponse.ReadOnly]
  def deleteParameterGroup(
      request: zio.aws.dax.model.DeleteParameterGroupRequest
  ): IO[AwsError, zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly]
  def deleteSubnetGroup(
      request: zio.aws.dax.model.DeleteSubnetGroupRequest
  ): IO[AwsError, ReadOnly]
  def tagResource(
      request: zio.aws.dax.model.TagResourceRequest
  ): IO[AwsError, zio.aws.dax.model.TagResourceResponse.ReadOnly]
  def createParameterGroup(
      request: zio.aws.dax.model.CreateParameterGroupRequest
  ): IO[AwsError, zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly]
  def updateSubnetGroup(
      request: zio.aws.dax.model.UpdateSubnetGroupRequest
  ): IO[AwsError, zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly]
  def describeSubnetGroups(
      request: zio.aws.dax.model.DescribeSubnetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.dax.model.SubnetGroup.ReadOnly]
  def describeSubnetGroupsPaginated(
      request: zio.aws.dax.model.DescribeSubnetGroupsRequest
  ): IO[AwsError, zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly]
  def describeEvents(
      request: zio.aws.dax.model.DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.dax.model.Event.ReadOnly]
  def describeEventsPaginated(
      request: zio.aws.dax.model.DescribeEventsRequest
  ): IO[AwsError, zio.aws.dax.model.DescribeEventsResponse.ReadOnly]
  def createSubnetGroup(
      request: zio.aws.dax.model.CreateSubnetGroupRequest
  ): IO[AwsError, zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly]
}
object Dax {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Dax] = customized(identity)
  def customized(
      customization: DaxAsyncClientBuilder => DaxAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Dax] = managed(
    customization
  ).toLayer
  def managed(
      customization: DaxAsyncClientBuilder => DaxAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Dax] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = DaxAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DaxAsyncClient, DaxAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[DaxAsyncClient, DaxAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new DaxImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DaxImpl[R](
      override val api: DaxAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Dax
      with AwsServiceBase[R] {
    override val serviceName: String = "Dax"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DaxImpl[R1] = new DaxImpl(api, newAspect, r)
    def describeClusters(
        request: zio.aws.dax.model.DescribeClustersRequest
    ): ZStream[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClustersRequest,
        DescribeClustersResponse,
        Cluster
      ](
        "describeClusters",
        api.describeClusters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.clusters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dax.model.Cluster.wrap(item))
        .provideEnvironment(r)
    def describeClustersPaginated(
        request: zio.aws.dax.model.DescribeClustersRequest
    ): IO[AwsError, zio.aws.dax.model.DescribeClustersResponse.ReadOnly] =
      asyncRequestResponse[DescribeClustersRequest, DescribeClustersResponse](
        "describeClusters",
        api.describeClusters
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.DescribeClustersResponse.wrap)
        .provideEnvironment(r)
    def increaseReplicationFactor(
        request: zio.aws.dax.model.IncreaseReplicationFactorRequest
    ): IO[
      AwsError,
      zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly
    ] = asyncRequestResponse[
      IncreaseReplicationFactorRequest,
      IncreaseReplicationFactorResponse
    ]("increaseReplicationFactor", api.increaseReplicationFactor)(
      request.buildAwsValue()
    ).map(zio.aws.dax.model.IncreaseReplicationFactorResponse.wrap)
      .provideEnvironment(r)
    def describeParameterGroups(
        request: zio.aws.dax.model.DescribeParameterGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.dax.model.ParameterGroup.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeParameterGroupsRequest,
        DescribeParameterGroupsResponse,
        ParameterGroup
      ](
        "describeParameterGroups",
        api.describeParameterGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameterGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dax.model.ParameterGroup.wrap(item))
        .provideEnvironment(r)
    def describeParameterGroupsPaginated(
        request: zio.aws.dax.model.DescribeParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeParameterGroupsRequest,
      DescribeParameterGroupsResponse
    ]("describeParameterGroups", api.describeParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.dax.model.DescribeParameterGroupsResponse.wrap)
      .provideEnvironment(r)
    def rebootNode(
        request: zio.aws.dax.model.RebootNodeRequest
    ): IO[AwsError, zio.aws.dax.model.RebootNodeResponse.ReadOnly] =
      asyncRequestResponse[RebootNodeRequest, RebootNodeResponse](
        "rebootNode",
        api.rebootNode
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.RebootNodeResponse.wrap)
        .provideEnvironment(r)
    def listTags(
        request: zio.aws.dax.model.ListTagsRequest
    ): ZStream[Any, AwsError, zio.aws.dax.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[ListTagsRequest, ListTagsResponse, Tag](
        "listTags",
        api.listTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dax.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsPaginated(
        request: zio.aws.dax.model.ListTagsRequest
    ): IO[AwsError, zio.aws.dax.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[ListTagsRequest, ListTagsResponse](
        "listTags",
        api.listTags
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def describeDefaultParameters(
        request: zio.aws.dax.model.DescribeDefaultParametersRequest
    ): ZStream[Any, AwsError, zio.aws.dax.model.Parameter.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeDefaultParametersRequest,
        DescribeDefaultParametersResponse,
        Parameter
      ](
        "describeDefaultParameters",
        api.describeDefaultParameters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dax.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeDefaultParametersPaginated(
        request: zio.aws.dax.model.DescribeDefaultParametersRequest
    ): IO[
      AwsError,
      zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDefaultParametersRequest,
      DescribeDefaultParametersResponse
    ]("describeDefaultParameters", api.describeDefaultParameters)(
      request.buildAwsValue()
    ).map(zio.aws.dax.model.DescribeDefaultParametersResponse.wrap)
      .provideEnvironment(r)
    def describeParameters(
        request: zio.aws.dax.model.DescribeParametersRequest
    ): ZStream[Any, AwsError, zio.aws.dax.model.Parameter.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeParametersRequest,
        DescribeParametersResponse,
        Parameter
      ](
        "describeParameters",
        api.describeParameters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dax.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeParametersPaginated(
        request: zio.aws.dax.model.DescribeParametersRequest
    ): IO[AwsError, zio.aws.dax.model.DescribeParametersResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeParametersRequest,
        DescribeParametersResponse
      ]("describeParameters", api.describeParameters)(request.buildAwsValue())
        .map(zio.aws.dax.model.DescribeParametersResponse.wrap)
        .provideEnvironment(r)
    def decreaseReplicationFactor(
        request: zio.aws.dax.model.DecreaseReplicationFactorRequest
    ): IO[
      AwsError,
      zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly
    ] = asyncRequestResponse[
      DecreaseReplicationFactorRequest,
      DecreaseReplicationFactorResponse
    ]("decreaseReplicationFactor", api.decreaseReplicationFactor)(
      request.buildAwsValue()
    ).map(zio.aws.dax.model.DecreaseReplicationFactorResponse.wrap)
      .provideEnvironment(r)
    def createCluster(
        request: zio.aws.dax.model.CreateClusterRequest
    ): IO[AwsError, zio.aws.dax.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[CreateClusterRequest, CreateClusterResponse](
        "createCluster",
        api.createCluster
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteCluster(
        request: zio.aws.dax.model.DeleteClusterRequest
    ): IO[AwsError, zio.aws.dax.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[DeleteClusterRequest, DeleteClusterResponse](
        "deleteCluster",
        api.deleteCluster
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def updateCluster(
        request: zio.aws.dax.model.UpdateClusterRequest
    ): IO[AwsError, zio.aws.dax.model.UpdateClusterResponse.ReadOnly] =
      asyncRequestResponse[UpdateClusterRequest, UpdateClusterResponse](
        "updateCluster",
        api.updateCluster
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.UpdateClusterResponse.wrap)
        .provideEnvironment(r)
    def updateParameterGroup(
        request: zio.aws.dax.model.UpdateParameterGroupRequest
    ): IO[AwsError, zio.aws.dax.model.UpdateParameterGroupResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateParameterGroupRequest,
        UpdateParameterGroupResponse
      ]("updateParameterGroup", api.updateParameterGroup)(
        request.buildAwsValue()
      ).map(zio.aws.dax.model.UpdateParameterGroupResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.dax.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.dax.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteParameterGroup(
        request: zio.aws.dax.model.DeleteParameterGroupRequest
    ): IO[AwsError, zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteParameterGroupRequest,
        DeleteParameterGroupResponse
      ]("deleteParameterGroup", api.deleteParameterGroup)(
        request.buildAwsValue()
      ).map(zio.aws.dax.model.DeleteParameterGroupResponse.wrap)
        .provideEnvironment(r)
    def deleteSubnetGroup(
        request: zio.aws.dax.model.DeleteSubnetGroupRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DeleteSubnetGroupRequest, DeleteSubnetGroupResponse](
        "deleteSubnetGroup",
        api.deleteSubnetGroup
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.DeleteSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.dax.model.TagResourceRequest
    ): IO[AwsError, zio.aws.dax.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createParameterGroup(
        request: zio.aws.dax.model.CreateParameterGroupRequest
    ): IO[AwsError, zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CreateParameterGroupRequest,
        CreateParameterGroupResponse
      ]("createParameterGroup", api.createParameterGroup)(
        request.buildAwsValue()
      ).map(zio.aws.dax.model.CreateParameterGroupResponse.wrap)
        .provideEnvironment(r)
    def updateSubnetGroup(
        request: zio.aws.dax.model.UpdateSubnetGroupRequest
    ): IO[AwsError, zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[UpdateSubnetGroupRequest, UpdateSubnetGroupResponse](
        "updateSubnetGroup",
        api.updateSubnetGroup
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.UpdateSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def describeSubnetGroups(
        request: zio.aws.dax.model.DescribeSubnetGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.dax.model.SubnetGroup.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSubnetGroupsRequest,
        DescribeSubnetGroupsResponse,
        SubnetGroup
      ](
        "describeSubnetGroups",
        api.describeSubnetGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.subnetGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dax.model.SubnetGroup.wrap(item))
        .provideEnvironment(r)
    def describeSubnetGroupsPaginated(
        request: zio.aws.dax.model.DescribeSubnetGroupsRequest
    ): IO[AwsError, zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeSubnetGroupsRequest,
        DescribeSubnetGroupsResponse
      ]("describeSubnetGroups", api.describeSubnetGroups)(
        request.buildAwsValue()
      ).map(zio.aws.dax.model.DescribeSubnetGroupsResponse.wrap)
        .provideEnvironment(r)
    def describeEvents(
        request: zio.aws.dax.model.DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.dax.model.Event.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeEventsRequest,
        DescribeEventsResponse,
        Event
      ](
        "describeEvents",
        api.describeEvents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.events().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dax.model.Event.wrap(item))
        .provideEnvironment(r)
    def describeEventsPaginated(
        request: zio.aws.dax.model.DescribeEventsRequest
    ): IO[AwsError, zio.aws.dax.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[DescribeEventsRequest, DescribeEventsResponse](
        "describeEvents",
        api.describeEvents
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
    def createSubnetGroup(
        request: zio.aws.dax.model.CreateSubnetGroupRequest
    ): IO[AwsError, zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[CreateSubnetGroupRequest, CreateSubnetGroupResponse](
        "createSubnetGroup",
        api.createSubnetGroup
      )(request.buildAwsValue())
        .map(zio.aws.dax.model.CreateSubnetGroupResponse.wrap)
        .provideEnvironment(r)
  }
  def describeClusters(
      request: zio.aws.dax.model.DescribeClustersRequest
  ): ZStream[zio.aws.dax.Dax, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
    ZStream.serviceWithStream(_.describeClusters(request))
  def describeClustersPaginated(
      request: zio.aws.dax.model.DescribeClustersRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DescribeClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClustersPaginated(request))
  def increaseReplicationFactor(
      request: zio.aws.dax.model.IncreaseReplicationFactorRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.increaseReplicationFactor(request))
  def describeParameterGroups(
      request: zio.aws.dax.model.DescribeParameterGroupsRequest
  ): ZStream[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.ParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeParameterGroups(request))
  def describeParameterGroupsPaginated(
      request: zio.aws.dax.model.DescribeParameterGroupsRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeParameterGroupsPaginated(request))
  def rebootNode(request: zio.aws.dax.model.RebootNodeRequest): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.RebootNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootNode(request))
  def listTags(
      request: zio.aws.dax.model.ListTagsRequest
  ): ZStream[zio.aws.dax.Dax, AwsError, zio.aws.dax.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listTags(request))
  def listTagsPaginated(request: zio.aws.dax.model.ListTagsRequest): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsPaginated(request))
  def describeDefaultParameters(
      request: zio.aws.dax.model.DescribeDefaultParametersRequest
  ): ZStream[zio.aws.dax.Dax, AwsError, zio.aws.dax.model.Parameter.ReadOnly] =
    ZStream.serviceWithStream(_.describeDefaultParameters(request))
  def describeDefaultParametersPaginated(
      request: zio.aws.dax.model.DescribeDefaultParametersRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDefaultParametersPaginated(request))
  def describeParameters(
      request: zio.aws.dax.model.DescribeParametersRequest
  ): ZStream[zio.aws.dax.Dax, AwsError, zio.aws.dax.model.Parameter.ReadOnly] =
    ZStream.serviceWithStream(_.describeParameters(request))
  def describeParametersPaginated(
      request: zio.aws.dax.model.DescribeParametersRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DescribeParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeParametersPaginated(request))
  def decreaseReplicationFactor(
      request: zio.aws.dax.model.DecreaseReplicationFactorRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.decreaseReplicationFactor(request))
  def createCluster(request: zio.aws.dax.model.CreateClusterRequest): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def deleteCluster(request: zio.aws.dax.model.DeleteClusterRequest): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def updateCluster(request: zio.aws.dax.model.UpdateClusterRequest): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.UpdateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCluster(request))
  def updateParameterGroup(
      request: zio.aws.dax.model.UpdateParameterGroupRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.UpdateParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateParameterGroup(request))
  def untagResource(request: zio.aws.dax.model.UntagResourceRequest): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteParameterGroup(
      request: zio.aws.dax.model.DeleteParameterGroupRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteParameterGroup(request))
  def deleteSubnetGroup(
      request: zio.aws.dax.model.DeleteSubnetGroupRequest
  ): ZIO[zio.aws.dax.Dax, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteSubnetGroup(request))
  def tagResource(request: zio.aws.dax.model.TagResourceRequest): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createParameterGroup(
      request: zio.aws.dax.model.CreateParameterGroupRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createParameterGroup(request))
  def updateSubnetGroup(
      request: zio.aws.dax.model.UpdateSubnetGroupRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubnetGroup(request))
  def describeSubnetGroups(
      request: zio.aws.dax.model.DescribeSubnetGroupsRequest
  ): ZStream[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.SubnetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSubnetGroups(request))
  def describeSubnetGroupsPaginated(
      request: zio.aws.dax.model.DescribeSubnetGroupsRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSubnetGroupsPaginated(request))
  def describeEvents(
      request: zio.aws.dax.model.DescribeEventsRequest
  ): ZStream[zio.aws.dax.Dax, AwsError, zio.aws.dax.model.Event.ReadOnly] =
    ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(
      request: zio.aws.dax.model.DescribeEventsRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
  def createSubnetGroup(
      request: zio.aws.dax.model.CreateSubnetGroupRequest
  ): ZIO[
    zio.aws.dax.Dax,
    AwsError,
    zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubnetGroup(request))
}
