package zio.aws.dax
import zio.aws.dax.model.DeleteSubnetGroupResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.dax.DaxAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.dax.model.{
  DeleteSubnetGroupRequest,
  UpdateClusterRequest,
  DescribeSubnetGroupsRequest,
  ListTagsRequest,
  RebootNodeRequest,
  DescribeEventsRequest,
  UpdateParameterGroupRequest,
  CreateParameterGroupRequest,
  DecreaseReplicationFactorRequest,
  CreateClusterRequest,
  UpdateSubnetGroupRequest,
  DeleteClusterRequest,
  CreateSubnetGroupRequest,
  IncreaseReplicationFactorRequest,
  DescribeDefaultParametersRequest,
  UntagResourceRequest,
  DeleteParameterGroupRequest,
  DescribeParametersRequest,
  DescribeParameterGroupsRequest,
  DescribeClustersRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object DaxMock extends Mock[Dax] {
  object DescribeClusters
      extends Stream[
        DescribeClustersRequest,
        AwsError,
        zio.aws.dax.model.Cluster.ReadOnly
      ]
  object DescribeClustersPaginated
      extends Effect[
        DescribeClustersRequest,
        AwsError,
        zio.aws.dax.model.DescribeClustersResponse.ReadOnly
      ]
  object IncreaseReplicationFactor
      extends Effect[
        IncreaseReplicationFactorRequest,
        AwsError,
        zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly
      ]
  object DescribeParameterGroups
      extends Stream[
        DescribeParameterGroupsRequest,
        AwsError,
        zio.aws.dax.model.ParameterGroup.ReadOnly
      ]
  object DescribeParameterGroupsPaginated
      extends Effect[
        DescribeParameterGroupsRequest,
        AwsError,
        zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly
      ]
  object RebootNode
      extends Effect[
        RebootNodeRequest,
        AwsError,
        zio.aws.dax.model.RebootNodeResponse.ReadOnly
      ]
  object ListTags
      extends Stream[ListTagsRequest, AwsError, zio.aws.dax.model.Tag.ReadOnly]
  object ListTagsPaginated
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.dax.model.ListTagsResponse.ReadOnly
      ]
  object DescribeDefaultParameters
      extends Stream[
        DescribeDefaultParametersRequest,
        AwsError,
        zio.aws.dax.model.Parameter.ReadOnly
      ]
  object DescribeDefaultParametersPaginated
      extends Effect[
        DescribeDefaultParametersRequest,
        AwsError,
        zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly
      ]
  object DescribeParameters
      extends Stream[
        DescribeParametersRequest,
        AwsError,
        zio.aws.dax.model.Parameter.ReadOnly
      ]
  object DescribeParametersPaginated
      extends Effect[
        DescribeParametersRequest,
        AwsError,
        zio.aws.dax.model.DescribeParametersResponse.ReadOnly
      ]
  object DecreaseReplicationFactor
      extends Effect[
        DecreaseReplicationFactorRequest,
        AwsError,
        zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.dax.model.CreateClusterResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.dax.model.DeleteClusterResponse.ReadOnly
      ]
  object UpdateCluster
      extends Effect[
        UpdateClusterRequest,
        AwsError,
        zio.aws.dax.model.UpdateClusterResponse.ReadOnly
      ]
  object UpdateParameterGroup
      extends Effect[
        UpdateParameterGroupRequest,
        AwsError,
        zio.aws.dax.model.UpdateParameterGroupResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.dax.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteParameterGroup
      extends Effect[
        DeleteParameterGroupRequest,
        AwsError,
        zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly
      ]
  object DeleteSubnetGroup
      extends Effect[DeleteSubnetGroupRequest, AwsError, ReadOnly]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.dax.model.TagResourceResponse.ReadOnly
      ]
  object CreateParameterGroup
      extends Effect[
        CreateParameterGroupRequest,
        AwsError,
        zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly
      ]
  object UpdateSubnetGroup
      extends Effect[
        UpdateSubnetGroupRequest,
        AwsError,
        zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly
      ]
  object DescribeSubnetGroups
      extends Stream[
        DescribeSubnetGroupsRequest,
        AwsError,
        zio.aws.dax.model.SubnetGroup.ReadOnly
      ]
  object DescribeSubnetGroupsPaginated
      extends Effect[
        DescribeSubnetGroupsRequest,
        AwsError,
        zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.dax.model.Event.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.dax.model.DescribeEventsResponse.ReadOnly
      ]
  object CreateSubnetGroup
      extends Effect[
        CreateSubnetGroupRequest,
        AwsError,
        zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Dax] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Dax {
          val api: DaxAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Dax = this
          def describeClusters(
              request: DescribeClustersRequest
          ): ZStream[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
            rts.unsafeRun(proxy(DescribeClusters, request))
          def describeClustersPaginated(
              request: DescribeClustersRequest
          ): IO[AwsError, zio.aws.dax.model.DescribeClustersResponse.ReadOnly] =
            proxy(DescribeClustersPaginated, request)
          def increaseReplicationFactor(
              request: IncreaseReplicationFactorRequest
          ): IO[
            AwsError,
            zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly
          ] = proxy(IncreaseReplicationFactor, request)
          def describeParameterGroups(
              request: DescribeParameterGroupsRequest
          ): ZStream[Any, AwsError, zio.aws.dax.model.ParameterGroup.ReadOnly] =
            rts.unsafeRun(proxy(DescribeParameterGroups, request))
          def describeParameterGroupsPaginated(
              request: DescribeParameterGroupsRequest
          ): IO[
            AwsError,
            zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly
          ] = proxy(DescribeParameterGroupsPaginated, request)
          def rebootNode(
              request: RebootNodeRequest
          ): IO[AwsError, zio.aws.dax.model.RebootNodeResponse.ReadOnly] =
            proxy(RebootNode, request)
          def listTags(
              request: ListTagsRequest
          ): ZStream[Any, AwsError, zio.aws.dax.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTags, request))
          def listTagsPaginated(
              request: ListTagsRequest
          ): IO[AwsError, zio.aws.dax.model.ListTagsResponse.ReadOnly] =
            proxy(ListTagsPaginated, request)
          def describeDefaultParameters(
              request: DescribeDefaultParametersRequest
          ): ZStream[Any, AwsError, zio.aws.dax.model.Parameter.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDefaultParameters, request))
          def describeDefaultParametersPaginated(
              request: DescribeDefaultParametersRequest
          ): IO[
            AwsError,
            zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly
          ] = proxy(DescribeDefaultParametersPaginated, request)
          def describeParameters(
              request: DescribeParametersRequest
          ): ZStream[Any, AwsError, zio.aws.dax.model.Parameter.ReadOnly] =
            rts.unsafeRun(proxy(DescribeParameters, request))
          def describeParametersPaginated(
              request: DescribeParametersRequest
          ): IO[
            AwsError,
            zio.aws.dax.model.DescribeParametersResponse.ReadOnly
          ] = proxy(DescribeParametersPaginated, request)
          def decreaseReplicationFactor(
              request: DecreaseReplicationFactorRequest
          ): IO[
            AwsError,
            zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly
          ] = proxy(DecreaseReplicationFactor, request)
          def createCluster(
              request: CreateClusterRequest
          ): IO[AwsError, zio.aws.dax.model.CreateClusterResponse.ReadOnly] =
            proxy(CreateCluster, request)
          def deleteCluster(
              request: DeleteClusterRequest
          ): IO[AwsError, zio.aws.dax.model.DeleteClusterResponse.ReadOnly] =
            proxy(DeleteCluster, request)
          def updateCluster(
              request: UpdateClusterRequest
          ): IO[AwsError, zio.aws.dax.model.UpdateClusterResponse.ReadOnly] =
            proxy(UpdateCluster, request)
          def updateParameterGroup(request: UpdateParameterGroupRequest): IO[
            AwsError,
            zio.aws.dax.model.UpdateParameterGroupResponse.ReadOnly
          ] = proxy(UpdateParameterGroup, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.dax.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def deleteParameterGroup(request: DeleteParameterGroupRequest): IO[
            AwsError,
            zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly
          ] = proxy(DeleteParameterGroup, request)
          def deleteSubnetGroup(
              request: DeleteSubnetGroupRequest
          ): IO[AwsError, ReadOnly] = proxy(DeleteSubnetGroup, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.dax.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def createParameterGroup(request: CreateParameterGroupRequest): IO[
            AwsError,
            zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly
          ] = proxy(CreateParameterGroup, request)
          def updateSubnetGroup(request: UpdateSubnetGroupRequest): IO[
            AwsError,
            zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly
          ] = proxy(UpdateSubnetGroup, request)
          def describeSubnetGroups(
              request: DescribeSubnetGroupsRequest
          ): ZStream[Any, AwsError, zio.aws.dax.model.SubnetGroup.ReadOnly] =
            rts.unsafeRun(proxy(DescribeSubnetGroups, request))
          def describeSubnetGroupsPaginated(
              request: DescribeSubnetGroupsRequest
          ): IO[
            AwsError,
            zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly
          ] = proxy(DescribeSubnetGroupsPaginated, request)
          def describeEvents(
              request: DescribeEventsRequest
          ): ZStream[Any, AwsError, zio.aws.dax.model.Event.ReadOnly] =
            rts.unsafeRun(proxy(DescribeEvents, request))
          def describeEventsPaginated(
              request: DescribeEventsRequest
          ): IO[AwsError, zio.aws.dax.model.DescribeEventsResponse.ReadOnly] =
            proxy(DescribeEventsPaginated, request)
          def createSubnetGroup(request: CreateSubnetGroupRequest): IO[
            AwsError,
            zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly
          ] = proxy(CreateSubnetGroup, request)
        }
      }
    }
    .toLayer
}
