package zio.aws.dax.model
import scala.jdk.CollectionConverters.*
sealed trait ChangeType {
  def unwrap: software.amazon.awssdk.services.dax.model.ChangeType
}
object ChangeType {
  def wrap(
      value: software.amazon.awssdk.services.dax.model.ChangeType
  ): zio.aws.dax.model.ChangeType = value match {
    case software.amazon.awssdk.services.dax.model.ChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dax.model.ChangeType.IMMEDIATE =>
      val r = IMMEDIATE
      r
    case software.amazon.awssdk.services.dax.model.ChangeType.REQUIRES_REBOOT =>
      val r = REQUIRES_REBOOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.dax.model.ChangeType {
    override def unwrap: software.amazon.awssdk.services.dax.model.ChangeType =
      software.amazon.awssdk.services.dax.model.ChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object IMMEDIATE extends zio.aws.dax.model.ChangeType {
    override def unwrap: software.amazon.awssdk.services.dax.model.ChangeType =
      software.amazon.awssdk.services.dax.model.ChangeType.IMMEDIATE
  }
  case object REQUIRES_REBOOT extends zio.aws.dax.model.ChangeType {
    override def unwrap: software.amazon.awssdk.services.dax.model.ChangeType =
      software.amazon.awssdk.services.dax.model.ChangeType.REQUIRES_REBOOT
  }
}
