package zio.aws.dax.model
import java.lang.Integer
import zio.aws.dax.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Cluster(
    clusterName: Option[String] = None,
    description: Option[String] = None,
    clusterArn: Option[String] = None,
    totalNodes: Option[IntegerOptional] = None,
    activeNodes: Option[IntegerOptional] = None,
    nodeType: Option[String] = None,
    status: Option[String] = None,
    clusterDiscoveryEndpoint: Option[zio.aws.dax.model.Endpoint] = None,
    nodeIdsToRemove: Option[Iterable[String]] = None,
    nodes: Option[Iterable[zio.aws.dax.model.Node]] = None,
    preferredMaintenanceWindow: Option[String] = None,
    notificationConfiguration: Option[
      zio.aws.dax.model.NotificationConfiguration
    ] = None,
    subnetGroup: Option[String] = None,
    securityGroups: Option[
      Iterable[zio.aws.dax.model.SecurityGroupMembership]
    ] = None,
    iamRoleArn: Option[String] = None,
    parameterGroup: Option[zio.aws.dax.model.ParameterGroupStatus] = None,
    sseDescription: Option[zio.aws.dax.model.SSEDescription] = None,
    clusterEndpointEncryptionType: Option[
      zio.aws.dax.model.ClusterEndpointEncryptionType
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dax.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.Cluster
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(totalNodes.map(value => value: Integer))(_.totalNodes)
      .optionallyWith(activeNodes.map(value => value: Integer))(_.activeNodes)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        clusterDiscoveryEndpoint.map(value => value.buildAwsValue())
      )(_.clusterDiscoveryEndpoint)
      .optionallyWith(
        nodeIdsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.nodeIdsToRemove)
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .optionallyWith(subnetGroup.map(value => value: java.lang.String))(
        _.subnetGroup
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(iamRoleArn.map(value => value: java.lang.String))(
        _.iamRoleArn
      )
      .optionallyWith(parameterGroup.map(value => value.buildAwsValue()))(
        _.parameterGroup
      )
      .optionallyWith(sseDescription.map(value => value.buildAwsValue()))(
        _.sseDescription
      )
      .optionallyWith(clusterEndpointEncryptionType.map(value => value.unwrap))(
        _.clusterEndpointEncryptionType
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.Cluster.ReadOnly =
    zio.aws.dax.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dax.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.Cluster = zio.aws.dax.model.Cluster(
      clusterName.map(value => value),
      description.map(value => value),
      clusterArn.map(value => value),
      totalNodes.map(value => value),
      activeNodes.map(value => value),
      nodeType.map(value => value),
      status.map(value => value),
      clusterDiscoveryEndpoint.map(value => value.asEditable),
      nodeIdsToRemove.map(value => value),
      nodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      preferredMaintenanceWindow.map(value => value),
      notificationConfiguration.map(value => value.asEditable),
      subnetGroup.map(value => value),
      securityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      iamRoleArn.map(value => value),
      parameterGroup.map(value => value.asEditable),
      sseDescription.map(value => value.asEditable),
      clusterEndpointEncryptionType.map(value => value)
    )
    def clusterName: Option[String]
    def description: Option[String]
    def clusterArn: Option[String]
    def totalNodes: Option[IntegerOptional]
    def activeNodes: Option[IntegerOptional]
    def nodeType: Option[String]
    def status: Option[String]
    def clusterDiscoveryEndpoint: Option[zio.aws.dax.model.Endpoint.ReadOnly]
    def nodeIdsToRemove: Option[List[String]]
    def nodes: Option[List[zio.aws.dax.model.Node.ReadOnly]]
    def preferredMaintenanceWindow: Option[String]
    def notificationConfiguration
        : Option[zio.aws.dax.model.NotificationConfiguration.ReadOnly]
    def subnetGroup: Option[String]
    def securityGroups
        : Option[List[zio.aws.dax.model.SecurityGroupMembership.ReadOnly]]
    def iamRoleArn: Option[String]
    def parameterGroup: Option[zio.aws.dax.model.ParameterGroupStatus.ReadOnly]
    def sseDescription: Option[zio.aws.dax.model.SSEDescription.ReadOnly]
    def clusterEndpointEncryptionType
        : Option[zio.aws.dax.model.ClusterEndpointEncryptionType]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getTotalNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("totalNodes", totalNodes)
    def getActiveNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("activeNodes", activeNodes)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getClusterDiscoveryEndpoint
        : ZIO[Any, AwsError, zio.aws.dax.model.Endpoint.ReadOnly] = AwsError
      .unwrapOptionField("clusterDiscoveryEndpoint", clusterDiscoveryEndpoint)
    def getNodeIdsToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("nodeIdsToRemove", nodeIdsToRemove)
    def getNodes: ZIO[Any, AwsError, List[zio.aws.dax.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodes", nodes)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.dax.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
    def getSubnetGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroup", subnetGroup)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.dax.model.SecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getParameterGroup
        : ZIO[Any, AwsError, zio.aws.dax.model.ParameterGroupStatus.ReadOnly] =
      AwsError.unwrapOptionField("parameterGroup", parameterGroup)
    def getSseDescription
        : ZIO[Any, AwsError, zio.aws.dax.model.SSEDescription.ReadOnly] =
      AwsError.unwrapOptionField("sseDescription", sseDescription)
    def getClusterEndpointEncryptionType
        : ZIO[Any, AwsError, zio.aws.dax.model.ClusterEndpointEncryptionType] =
      AwsError.unwrapOptionField(
        "clusterEndpointEncryptionType",
        clusterEndpointEncryptionType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.Cluster
  ) extends zio.aws.dax.model.Cluster.ReadOnly {
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val clusterArn: Option[String] =
      scala.Option(impl.clusterArn()).map(value => value: String)
    override val totalNodes: Option[IntegerOptional] =
      scala.Option(impl.totalNodes()).map(value => value: IntegerOptional)
    override val activeNodes: Option[IntegerOptional] =
      scala.Option(impl.activeNodes()).map(value => value: IntegerOptional)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val clusterDiscoveryEndpoint
        : Option[zio.aws.dax.model.Endpoint.ReadOnly] = scala
      .Option(impl.clusterDiscoveryEndpoint())
      .map(value => zio.aws.dax.model.Endpoint.wrap(value))
    override val nodeIdsToRemove: Option[List[String]] = scala
      .Option(impl.nodeIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nodes: Option[List[zio.aws.dax.model.Node.ReadOnly]] = scala
      .Option(impl.nodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.Node.wrap(item)
        }.toList
      )
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val notificationConfiguration
        : Option[zio.aws.dax.model.NotificationConfiguration.ReadOnly] = scala
      .Option(impl.notificationConfiguration())
      .map(value => zio.aws.dax.model.NotificationConfiguration.wrap(value))
    override val subnetGroup: Option[String] =
      scala.Option(impl.subnetGroup()).map(value => value: String)
    override val securityGroups
        : Option[List[zio.aws.dax.model.SecurityGroupMembership.ReadOnly]] =
      scala
        .Option(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dax.model.SecurityGroupMembership.wrap(item)
          }.toList
        )
    override val iamRoleArn: Option[String] =
      scala.Option(impl.iamRoleArn()).map(value => value: String)
    override val parameterGroup
        : Option[zio.aws.dax.model.ParameterGroupStatus.ReadOnly] = scala
      .Option(impl.parameterGroup())
      .map(value => zio.aws.dax.model.ParameterGroupStatus.wrap(value))
    override val sseDescription
        : Option[zio.aws.dax.model.SSEDescription.ReadOnly] = scala
      .Option(impl.sseDescription())
      .map(value => zio.aws.dax.model.SSEDescription.wrap(value))
    override val clusterEndpointEncryptionType
        : Option[zio.aws.dax.model.ClusterEndpointEncryptionType] = scala
      .Option(impl.clusterEndpointEncryptionType())
      .map(value => zio.aws.dax.model.ClusterEndpointEncryptionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.Cluster
  ): zio.aws.dax.model.Cluster.ReadOnly = new Wrapper(impl)
}
