package zio.aws.dax.model
import zio.aws.dax.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterRequest(
    clusterName: String,
    nodeType: String,
    description: Option[String] = None,
    replicationFactor: Integer,
    availabilityZones: Option[Iterable[String]] = None,
    subnetGroupName: Option[String] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    preferredMaintenanceWindow: Option[String] = None,
    notificationTopicArn: Option[String] = None,
    iamRoleArn: String,
    parameterGroupName: Option[String] = None,
    tags: Option[Iterable[zio.aws.dax.model.Tag]] = None,
    sseSpecification: Option[zio.aws.dax.model.SSESpecification] = None,
    clusterEndpointEncryptionType: Option[
      zio.aws.dax.model.ClusterEndpointEncryptionType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.CreateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodeType(nodeType: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .replicationFactor(replicationFactor: java.lang.Integer)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .iamRoleArn(iamRoleArn: java.lang.String)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .optionallyWith(clusterEndpointEncryptionType.map(value => value.unwrap))(
        _.clusterEndpointEncryptionType
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.CreateClusterRequest.ReadOnly =
    zio.aws.dax.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.CreateClusterRequest =
      zio.aws.dax.model.CreateClusterRequest(
        clusterName,
        nodeType,
        description.map(value => value),
        replicationFactor,
        availabilityZones.map(value => value),
        subnetGroupName.map(value => value),
        securityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        notificationTopicArn.map(value => value),
        iamRoleArn,
        parameterGroupName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sseSpecification.map(value => value.asEditable),
        clusterEndpointEncryptionType.map(value => value)
      )
    def clusterName: String
    def nodeType: String
    def description: Option[String]
    def replicationFactor: Integer
    def availabilityZones: Option[List[String]]
    def subnetGroupName: Option[String]
    def securityGroupIds: Option[List[String]]
    def preferredMaintenanceWindow: Option[String]
    def notificationTopicArn: Option[String]
    def iamRoleArn: String
    def parameterGroupName: Option[String]
    def tags: Option[List[zio.aws.dax.model.Tag.ReadOnly]]
    def sseSpecification: Option[zio.aws.dax.model.SSESpecification.ReadOnly]
    def clusterEndpointEncryptionType
        : Option[zio.aws.dax.model.ClusterEndpointEncryptionType]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodeType: ZIO[Any, Nothing, String] = ZIO.succeed(nodeType)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getReplicationFactor: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(replicationFactor)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getIamRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(iamRoleArn)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.dax.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSseSpecification
        : ZIO[Any, AwsError, zio.aws.dax.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField("sseSpecification", sseSpecification)
    def getClusterEndpointEncryptionType
        : ZIO[Any, AwsError, zio.aws.dax.model.ClusterEndpointEncryptionType] =
      AwsError.unwrapOptionField(
        "clusterEndpointEncryptionType",
        clusterEndpointEncryptionType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.CreateClusterRequest
  ) extends zio.aws.dax.model.CreateClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodeType: String = impl.nodeType(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val replicationFactor: Integer = impl.replicationFactor(): Integer
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val subnetGroupName: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val notificationTopicArn: Option[String] =
      scala.Option(impl.notificationTopicArn()).map(value => value: String)
    override val iamRoleArn: String = impl.iamRoleArn(): String
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val tags: Option[List[zio.aws.dax.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.Tag.wrap(item)
        }.toList
      )
    override val sseSpecification
        : Option[zio.aws.dax.model.SSESpecification.ReadOnly] = scala
      .Option(impl.sseSpecification())
      .map(value => zio.aws.dax.model.SSESpecification.wrap(value))
    override val clusterEndpointEncryptionType
        : Option[zio.aws.dax.model.ClusterEndpointEncryptionType] = scala
      .Option(impl.clusterEndpointEncryptionType())
      .map(value => zio.aws.dax.model.ClusterEndpointEncryptionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.CreateClusterRequest
  ): zio.aws.dax.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
