package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterResponse(
    cluster: Option[zio.aws.dax.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.CreateClusterResponse.ReadOnly =
    zio.aws.dax.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.CreateClusterResponse = zio.aws.dax.model
      .CreateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.dax.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.CreateClusterResponse
  ) extends zio.aws.dax.model.CreateClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.dax.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.dax.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.CreateClusterResponse
  ): zio.aws.dax.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
