package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateParameterGroupRequest(
    parameterGroupName: String,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest = {
    import CreateParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.CreateParameterGroupRequest.ReadOnly =
    zio.aws.dax.model.CreateParameterGroupRequest.wrap(buildAwsValue())
}
object CreateParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.CreateParameterGroupRequest =
      zio.aws.dax.model.CreateParameterGroupRequest(
        parameterGroupName,
        description.map(value => value)
      )
    def parameterGroupName: String
    def description: Option[String]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest
  ) extends zio.aws.dax.model.CreateParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest
  ): zio.aws.dax.model.CreateParameterGroupRequest.ReadOnly = new Wrapper(impl)
}
