package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateParameterGroupResponse(
    parameterGroup: Option[zio.aws.dax.model.ParameterGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse = {
    import CreateParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroup.map(value => value.buildAwsValue()))(
        _.parameterGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly =
    zio.aws.dax.model.CreateParameterGroupResponse.wrap(buildAwsValue())
}
object CreateParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.CreateParameterGroupResponse =
      zio.aws.dax.model.CreateParameterGroupResponse(
        parameterGroup.map(value => value.asEditable)
      )
    def parameterGroup: Option[zio.aws.dax.model.ParameterGroup.ReadOnly]
    def getParameterGroup
        : ZIO[Any, AwsError, zio.aws.dax.model.ParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("parameterGroup", parameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse
  ) extends zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly {
    override val parameterGroup
        : Option[zio.aws.dax.model.ParameterGroup.ReadOnly] = scala
      .Option(impl.parameterGroup())
      .map(value => zio.aws.dax.model.ParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse
  ): zio.aws.dax.model.CreateParameterGroupResponse.ReadOnly = new Wrapper(impl)
}
