package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSubnetGroupRequest(
    subnetGroupName: String,
    description: Option[String] = None,
    subnetIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest = {
    import CreateSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest
      .builder()
      .subnetGroupName(subnetGroupName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.CreateSubnetGroupRequest.ReadOnly =
    zio.aws.dax.model.CreateSubnetGroupRequest.wrap(buildAwsValue())
}
object CreateSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.CreateSubnetGroupRequest =
      zio.aws.dax.model.CreateSubnetGroupRequest(
        subnetGroupName,
        description.map(value => value),
        subnetIds
      )
    def subnetGroupName: String
    def description: Option[String]
    def subnetIds: List[String]
    def getSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest
  ) extends zio.aws.dax.model.CreateSubnetGroupRequest.ReadOnly {
    override val subnetGroupName: String = impl.subnetGroupName(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest
  ): zio.aws.dax.model.CreateSubnetGroupRequest.ReadOnly = new Wrapper(impl)
}
