package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSubnetGroupResponse(
    subnetGroup: Option[zio.aws.dax.model.SubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse = {
    import CreateSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse
      .builder()
      .optionallyWith(subnetGroup.map(value => value.buildAwsValue()))(
        _.subnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly =
    zio.aws.dax.model.CreateSubnetGroupResponse.wrap(buildAwsValue())
}
object CreateSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.CreateSubnetGroupResponse =
      zio.aws.dax.model
        .CreateSubnetGroupResponse(subnetGroup.map(value => value.asEditable))
    def subnetGroup: Option[zio.aws.dax.model.SubnetGroup.ReadOnly]
    def getSubnetGroup
        : ZIO[Any, AwsError, zio.aws.dax.model.SubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("subnetGroup", subnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse
  ) extends zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly {
    override val subnetGroup: Option[zio.aws.dax.model.SubnetGroup.ReadOnly] =
      scala
        .Option(impl.subnetGroup())
        .map(value => zio.aws.dax.model.SubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse
  ): zio.aws.dax.model.CreateSubnetGroupResponse.ReadOnly = new Wrapper(impl)
}
