package zio.aws.dax.model
import zio.aws.dax.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DecreaseReplicationFactorRequest(
    clusterName: String,
    newReplicationFactor: Integer,
    availabilityZones: Option[Iterable[String]] = None,
    nodeIdsToRemove: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest = {
    import DecreaseReplicationFactorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .newReplicationFactor(newReplicationFactor: java.lang.Integer)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        nodeIdsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.nodeIdsToRemove)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DecreaseReplicationFactorRequest.ReadOnly =
    zio.aws.dax.model.DecreaseReplicationFactorRequest.wrap(buildAwsValue())
}
object DecreaseReplicationFactorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DecreaseReplicationFactorRequest =
      zio.aws.dax.model.DecreaseReplicationFactorRequest(
        clusterName,
        newReplicationFactor,
        availabilityZones.map(value => value),
        nodeIdsToRemove.map(value => value)
      )
    def clusterName: String
    def newReplicationFactor: Integer
    def availabilityZones: Option[List[String]]
    def nodeIdsToRemove: Option[List[String]]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNewReplicationFactor: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(newReplicationFactor)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getNodeIdsToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("nodeIdsToRemove", nodeIdsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest
  ) extends zio.aws.dax.model.DecreaseReplicationFactorRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val newReplicationFactor: Integer =
      impl.newReplicationFactor(): Integer
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nodeIdsToRemove: Option[List[String]] = scala
      .Option(impl.nodeIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest
  ): zio.aws.dax.model.DecreaseReplicationFactorRequest.ReadOnly = new Wrapper(
    impl
  )
}
