package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DecreaseReplicationFactorResponse(
    cluster: Option[zio.aws.dax.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse = {
    import DecreaseReplicationFactorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly =
    zio.aws.dax.model.DecreaseReplicationFactorResponse.wrap(buildAwsValue())
}
object DecreaseReplicationFactorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DecreaseReplicationFactorResponse =
      zio.aws.dax.model.DecreaseReplicationFactorResponse(
        cluster.map(value => value.asEditable)
      )
    def cluster: Option[zio.aws.dax.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse
  ) extends zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly {
    override val cluster: Option[zio.aws.dax.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.dax.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse
  ): zio.aws.dax.model.DecreaseReplicationFactorResponse.ReadOnly = new Wrapper(
    impl
  )
}
