package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteClusterRequest(clusterName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DeleteClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DeleteClusterRequest.ReadOnly =
    zio.aws.dax.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DeleteClusterRequest =
      zio.aws.dax.model.DeleteClusterRequest(clusterName)
    def clusterName: String
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DeleteClusterRequest
  ) extends zio.aws.dax.model.DeleteClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DeleteClusterRequest
  ): zio.aws.dax.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
