package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteClusterResponse(
    cluster: Option[zio.aws.dax.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DeleteClusterResponse = {
    import DeleteClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DeleteClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DeleteClusterResponse.ReadOnly =
    zio.aws.dax.model.DeleteClusterResponse.wrap(buildAwsValue())
}
object DeleteClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DeleteClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DeleteClusterResponse = zio.aws.dax.model
      .DeleteClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.dax.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DeleteClusterResponse
  ) extends zio.aws.dax.model.DeleteClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.dax.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.dax.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DeleteClusterResponse
  ): zio.aws.dax.model.DeleteClusterResponse.ReadOnly = new Wrapper(impl)
}
