package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteParameterGroupRequest(parameterGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest = {
    import DeleteParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DeleteParameterGroupRequest.ReadOnly =
    zio.aws.dax.model.DeleteParameterGroupRequest.wrap(buildAwsValue())
}
object DeleteParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DeleteParameterGroupRequest =
      zio.aws.dax.model.DeleteParameterGroupRequest(parameterGroupName)
    def parameterGroupName: String
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest
  ) extends zio.aws.dax.model.DeleteParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest
  ): zio.aws.dax.model.DeleteParameterGroupRequest.ReadOnly = new Wrapper(impl)
}
