package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteParameterGroupResponse(
    deletionMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse = {
    import DeleteParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse
      .builder()
      .optionallyWith(deletionMessage.map(value => value: java.lang.String))(
        _.deletionMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly =
    zio.aws.dax.model.DeleteParameterGroupResponse.wrap(buildAwsValue())
}
object DeleteParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DeleteParameterGroupResponse =
      zio.aws.dax.model
        .DeleteParameterGroupResponse(deletionMessage.map(value => value))
    def deletionMessage: Option[String]
    def getDeletionMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deletionMessage", deletionMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse
  ) extends zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly {
    override val deletionMessage: Option[String] =
      scala.Option(impl.deletionMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse
  ): zio.aws.dax.model.DeleteParameterGroupResponse.ReadOnly = new Wrapper(impl)
}
