package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSubnetGroupRequest(subnetGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest = {
    import DeleteSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest
      .builder()
      .subnetGroupName(subnetGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DeleteSubnetGroupRequest.ReadOnly =
    zio.aws.dax.model.DeleteSubnetGroupRequest.wrap(buildAwsValue())
}
object DeleteSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DeleteSubnetGroupRequest =
      zio.aws.dax.model.DeleteSubnetGroupRequest(subnetGroupName)
    def subnetGroupName: String
    def getSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest
  ) extends zio.aws.dax.model.DeleteSubnetGroupRequest.ReadOnly {
    override val subnetGroupName: String = impl.subnetGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest
  ): zio.aws.dax.model.DeleteSubnetGroupRequest.ReadOnly = new Wrapper(impl)
}
