package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSubnetGroupResponse(
    deletionMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse = {
    import DeleteSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse
      .builder()
      .optionallyWith(deletionMessage.map(value => value: java.lang.String))(
        _.deletionMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DeleteSubnetGroupResponse.ReadOnly =
    zio.aws.dax.model.DeleteSubnetGroupResponse.wrap(buildAwsValue())
}
object DeleteSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DeleteSubnetGroupResponse =
      zio.aws.dax.model
        .DeleteSubnetGroupResponse(deletionMessage.map(value => value))
    def deletionMessage: Option[String]
    def getDeletionMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deletionMessage", deletionMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse
  ) extends zio.aws.dax.model.DeleteSubnetGroupResponse.ReadOnly {
    override val deletionMessage: Option[String] =
      scala.Option(impl.deletionMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse
  ): zio.aws.dax.model.DeleteSubnetGroupResponse.ReadOnly = new Wrapper(impl)
}
