package zio.aws.dax.model
import java.lang.Integer
import zio.aws.dax.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClustersRequest(
    clusterNames: Option[Iterable[String]] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeClustersRequest = {
    import DescribeClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeClustersRequest
      .builder()
      .optionallyWith(
        clusterNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterNames)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeClustersRequest.ReadOnly =
    zio.aws.dax.model.DescribeClustersRequest.wrap(buildAwsValue())
}
object DescribeClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeClustersRequest =
      zio.aws.dax.model.DescribeClustersRequest(
        clusterNames.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterNames: Option[List[String]]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getClusterNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterNames", clusterNames)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeClustersRequest
  ) extends zio.aws.dax.model.DescribeClustersRequest.ReadOnly {
    override val clusterNames: Option[List[String]] = scala
      .Option(impl.clusterNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeClustersRequest
  ): zio.aws.dax.model.DescribeClustersRequest.ReadOnly = new Wrapper(impl)
}
