package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClustersResponse(
    nextToken: Option[String] = None,
    clusters: Option[Iterable[zio.aws.dax.model.Cluster]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeClustersResponse = {
    import DescribeClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeClustersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeClustersResponse.ReadOnly =
    zio.aws.dax.model.DescribeClustersResponse.wrap(buildAwsValue())
}
object DescribeClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeClustersResponse =
      zio.aws.dax.model.DescribeClustersResponse(
        nextToken.map(value => value),
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def clusters: Option[List[zio.aws.dax.model.Cluster.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.dax.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeClustersResponse
  ) extends zio.aws.dax.model.DescribeClustersResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val clusters: Option[List[zio.aws.dax.model.Cluster.ReadOnly]] =
      scala
        .Option(impl.clusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dax.model.Cluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeClustersResponse
  ): zio.aws.dax.model.DescribeClustersResponse.ReadOnly = new Wrapper(impl)
}
