package zio.aws.dax.model
import java.lang.Integer
import zio.aws.dax.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDefaultParametersRequest(
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest = {
    import DescribeDefaultParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeDefaultParametersRequest.ReadOnly =
    zio.aws.dax.model.DescribeDefaultParametersRequest.wrap(buildAwsValue())
}
object DescribeDefaultParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeDefaultParametersRequest =
      zio.aws.dax.model.DescribeDefaultParametersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest
  ) extends zio.aws.dax.model.DescribeDefaultParametersRequest.ReadOnly {
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest
  ): zio.aws.dax.model.DescribeDefaultParametersRequest.ReadOnly = new Wrapper(
    impl
  )
}
