package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDefaultParametersResponse(
    nextToken: Option[String] = None,
    parameters: Option[Iterable[zio.aws.dax.model.Parameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse = {
    import DescribeDefaultParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly =
    zio.aws.dax.model.DescribeDefaultParametersResponse.wrap(buildAwsValue())
}
object DescribeDefaultParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeDefaultParametersResponse =
      zio.aws.dax.model.DescribeDefaultParametersResponse(
        nextToken.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def parameters: Option[List[zio.aws.dax.model.Parameter.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.dax.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse
  ) extends zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val parameters
        : Option[List[zio.aws.dax.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse
  ): zio.aws.dax.model.DescribeDefaultParametersResponse.ReadOnly = new Wrapper(
    impl
  )
}
