package zio.aws.dax.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dax.model.primitives.{IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEventsRequest(
    sourceName: Option[String] = None,
    sourceType: Option[zio.aws.dax.model.SourceType] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    duration: Option[IntegerOptional] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeEventsRequest
      .builder()
      .optionallyWith(sourceName.map(value => value: java.lang.String))(
        _.sourceName
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeEventsRequest.ReadOnly =
    zio.aws.dax.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeEventsRequest =
      zio.aws.dax.model.DescribeEventsRequest(
        sourceName.map(value => value),
        sourceType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        duration.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sourceName: Option[String]
    def sourceType: Option[zio.aws.dax.model.SourceType]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def duration: Option[IntegerOptional]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getSourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceType: ZIO[Any, AwsError, zio.aws.dax.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("duration", duration)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeEventsRequest
  ) extends zio.aws.dax.model.DescribeEventsRequest.ReadOnly {
    override val sourceName: Option[String] =
      scala.Option(impl.sourceName()).map(value => value: String)
    override val sourceType: Option[zio.aws.dax.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.dax.model.SourceType.wrap(value))
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.dax.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.dax.model.primitives.TStamp(value))
    override val duration: Option[IntegerOptional] =
      scala.Option(impl.duration()).map(value => value: IntegerOptional)
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeEventsRequest
  ): zio.aws.dax.model.DescribeEventsRequest.ReadOnly = new Wrapper(impl)
}
