package zio.aws.dax.model
import java.lang.Integer
import zio.aws.dax.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParameterGroupsRequest(
    parameterGroupNames: Option[Iterable[String]] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest = {
    import DescribeParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest
      .builder()
      .optionallyWith(
        parameterGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.parameterGroupNames)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeParameterGroupsRequest.ReadOnly =
    zio.aws.dax.model.DescribeParameterGroupsRequest.wrap(buildAwsValue())
}
object DescribeParameterGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeParameterGroupsRequest =
      zio.aws.dax.model.DescribeParameterGroupsRequest(
        parameterGroupNames.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def parameterGroupNames: Option[List[String]]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getParameterGroupNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("parameterGroupNames", parameterGroupNames)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest
  ) extends zio.aws.dax.model.DescribeParameterGroupsRequest.ReadOnly {
    override val parameterGroupNames: Option[List[String]] = scala
      .Option(impl.parameterGroupNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest
  ): zio.aws.dax.model.DescribeParameterGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
