package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParameterGroupsResponse(
    nextToken: Option[String] = None,
    parameterGroups: Option[Iterable[zio.aws.dax.model.ParameterGroup]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse = {
    import DescribeParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        parameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterGroups)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly =
    zio.aws.dax.model.DescribeParameterGroupsResponse.wrap(buildAwsValue())
}
object DescribeParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeParameterGroupsResponse =
      zio.aws.dax.model.DescribeParameterGroupsResponse(
        nextToken.map(value => value),
        parameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def parameterGroups: Option[List[zio.aws.dax.model.ParameterGroup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParameterGroups
        : ZIO[Any, AwsError, List[zio.aws.dax.model.ParameterGroup.ReadOnly]] =
      AwsError.unwrapOptionField("parameterGroups", parameterGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse
  ) extends zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val parameterGroups
        : Option[List[zio.aws.dax.model.ParameterGroup.ReadOnly]] = scala
      .Option(impl.parameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.ParameterGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse
  ): zio.aws.dax.model.DescribeParameterGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
