package zio.aws.dax.model
import java.lang.Integer
import zio.aws.dax.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParametersRequest(
    parameterGroupName: String,
    source: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeParametersRequest = {
    import DescribeParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeParametersRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeParametersRequest.ReadOnly =
    zio.aws.dax.model.DescribeParametersRequest.wrap(buildAwsValue())
}
object DescribeParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeParametersRequest =
      zio.aws.dax.model.DescribeParametersRequest(
        parameterGroupName,
        source.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def parameterGroupName: String
    def source: Option[String]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeParametersRequest
  ) extends zio.aws.dax.model.DescribeParametersRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeParametersRequest
  ): zio.aws.dax.model.DescribeParametersRequest.ReadOnly = new Wrapper(impl)
}
