package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParametersResponse(
    nextToken: Option[String] = None,
    parameters: Option[Iterable[zio.aws.dax.model.Parameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeParametersResponse = {
    import DescribeParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeParametersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeParametersResponse.ReadOnly =
    zio.aws.dax.model.DescribeParametersResponse.wrap(buildAwsValue())
}
object DescribeParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeParametersResponse =
      zio.aws.dax.model.DescribeParametersResponse(
        nextToken.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def parameters: Option[List[zio.aws.dax.model.Parameter.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.dax.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeParametersResponse
  ) extends zio.aws.dax.model.DescribeParametersResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val parameters
        : Option[List[zio.aws.dax.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeParametersResponse
  ): zio.aws.dax.model.DescribeParametersResponse.ReadOnly = new Wrapper(impl)
}
