package zio.aws.dax.model
import java.lang.Integer
import zio.aws.dax.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSubnetGroupsRequest(
    subnetGroupNames: Option[Iterable[String]] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest = {
    import DescribeSubnetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest
      .builder()
      .optionallyWith(
        subnetGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetGroupNames)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeSubnetGroupsRequest.ReadOnly =
    zio.aws.dax.model.DescribeSubnetGroupsRequest.wrap(buildAwsValue())
}
object DescribeSubnetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeSubnetGroupsRequest =
      zio.aws.dax.model.DescribeSubnetGroupsRequest(
        subnetGroupNames.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def subnetGroupNames: Option[List[String]]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getSubnetGroupNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetGroupNames", subnetGroupNames)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest
  ) extends zio.aws.dax.model.DescribeSubnetGroupsRequest.ReadOnly {
    override val subnetGroupNames: Option[List[String]] = scala
      .Option(impl.subnetGroupNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest
  ): zio.aws.dax.model.DescribeSubnetGroupsRequest.ReadOnly = new Wrapper(impl)
}
