package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSubnetGroupsResponse(
    nextToken: Option[String] = None,
    subnetGroups: Option[Iterable[zio.aws.dax.model.SubnetGroup]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse = {
    import DescribeSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        subnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetGroups)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly =
    zio.aws.dax.model.DescribeSubnetGroupsResponse.wrap(buildAwsValue())
}
object DescribeSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.DescribeSubnetGroupsResponse =
      zio.aws.dax.model.DescribeSubnetGroupsResponse(
        nextToken.map(value => value),
        subnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def subnetGroups: Option[List[zio.aws.dax.model.SubnetGroup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSubnetGroups
        : ZIO[Any, AwsError, List[zio.aws.dax.model.SubnetGroup.ReadOnly]] =
      AwsError.unwrapOptionField("subnetGroups", subnetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse
  ) extends zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val subnetGroups
        : Option[List[zio.aws.dax.model.SubnetGroup.ReadOnly]] = scala
      .Option(impl.subnetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.SubnetGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse
  ): zio.aws.dax.model.DescribeSubnetGroupsResponse.ReadOnly = new Wrapper(impl)
}
