package zio.aws.dax.model
import zio.aws.dax.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Endpoint(
    address: Option[String] = None,
    port: Option[Integer] = None,
    url: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dax.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.Endpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.Endpoint.ReadOnly =
    zio.aws.dax.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dax.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.Endpoint = zio.aws.dax.model.Endpoint(
      address.map(value => value),
      port.map(value => value),
      url.map(value => value)
    )
    def address: Option[String]
    def port: Option[Integer]
    def url: Option[String]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.Endpoint
  ) extends zio.aws.dax.model.Endpoint.ReadOnly {
    override val address: Option[String] =
      scala.Option(impl.address()).map(value => value: String)
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.Endpoint
  ): zio.aws.dax.model.Endpoint.ReadOnly = new Wrapper(impl)
}
