package zio.aws.dax.model
import zio.aws.dax.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Event(
    sourceName: Option[String] = None,
    sourceType: Option[zio.aws.dax.model.SourceType] = None,
    message: Option[String] = None,
    date: Option[TStamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dax.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.Event
      .builder()
      .optionallyWith(sourceName.map(value => value: java.lang.String))(
        _.sourceName
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.Event.ReadOnly =
    zio.aws.dax.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dax.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.Event = zio.aws.dax.model.Event(
      sourceName.map(value => value),
      sourceType.map(value => value),
      message.map(value => value),
      date.map(value => value)
    )
    def sourceName: Option[String]
    def sourceType: Option[zio.aws.dax.model.SourceType]
    def message: Option[String]
    def date: Option[TStamp]
    def getSourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceType: ZIO[Any, AwsError, zio.aws.dax.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.Event
  ) extends zio.aws.dax.model.Event.ReadOnly {
    override val sourceName: Option[String] =
      scala.Option(impl.sourceName()).map(value => value: String)
    override val sourceType: Option[zio.aws.dax.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.dax.model.SourceType.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val date: Option[TStamp] = scala
      .Option(impl.date())
      .map(value => zio.aws.dax.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.Event
  ): zio.aws.dax.model.Event.ReadOnly = new Wrapper(impl)
}
