package zio.aws.dax.model
import zio.aws.dax.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IncreaseReplicationFactorRequest(
    clusterName: String,
    newReplicationFactor: Integer,
    availabilityZones: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest = {
    import IncreaseReplicationFactorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .newReplicationFactor(newReplicationFactor: java.lang.Integer)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.IncreaseReplicationFactorRequest.ReadOnly =
    zio.aws.dax.model.IncreaseReplicationFactorRequest.wrap(buildAwsValue())
}
object IncreaseReplicationFactorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.IncreaseReplicationFactorRequest =
      zio.aws.dax.model.IncreaseReplicationFactorRequest(
        clusterName,
        newReplicationFactor,
        availabilityZones.map(value => value)
      )
    def clusterName: String
    def newReplicationFactor: Integer
    def availabilityZones: Option[List[String]]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNewReplicationFactor: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(newReplicationFactor)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest
  ) extends zio.aws.dax.model.IncreaseReplicationFactorRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val newReplicationFactor: Integer =
      impl.newReplicationFactor(): Integer
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest
  ): zio.aws.dax.model.IncreaseReplicationFactorRequest.ReadOnly = new Wrapper(
    impl
  )
}
