package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IncreaseReplicationFactorResponse(
    cluster: Option[zio.aws.dax.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse = {
    import IncreaseReplicationFactorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly =
    zio.aws.dax.model.IncreaseReplicationFactorResponse.wrap(buildAwsValue())
}
object IncreaseReplicationFactorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.IncreaseReplicationFactorResponse =
      zio.aws.dax.model.IncreaseReplicationFactorResponse(
        cluster.map(value => value.asEditable)
      )
    def cluster: Option[zio.aws.dax.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse
  ) extends zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly {
    override val cluster: Option[zio.aws.dax.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.dax.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse
  ): zio.aws.dax.model.IncreaseReplicationFactorResponse.ReadOnly = new Wrapper(
    impl
  )
}
