package zio.aws.dax.model
import scala.jdk.CollectionConverters.*
sealed trait IsModifiable {
  def unwrap: software.amazon.awssdk.services.dax.model.IsModifiable
}
object IsModifiable {
  def wrap(
      value: software.amazon.awssdk.services.dax.model.IsModifiable
  ): zio.aws.dax.model.IsModifiable = value match {
    case software.amazon.awssdk.services.dax.model.IsModifiable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dax.model.IsModifiable.TRUE =>
      val r = TRUE
      r
    case software.amazon.awssdk.services.dax.model.IsModifiable.FALSE =>
      val r = FALSE
      r
    case software.amazon.awssdk.services.dax.model.IsModifiable.CONDITIONAL =>
      val r = CONDITIONAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.dax.model.IsModifiable {
    override def unwrap
        : software.amazon.awssdk.services.dax.model.IsModifiable =
      software.amazon.awssdk.services.dax.model.IsModifiable.UNKNOWN_TO_SDK_VERSION
  }
  case object TRUE extends zio.aws.dax.model.IsModifiable {
    override def unwrap
        : software.amazon.awssdk.services.dax.model.IsModifiable =
      software.amazon.awssdk.services.dax.model.IsModifiable.TRUE
  }
  case object FALSE extends zio.aws.dax.model.IsModifiable {
    override def unwrap
        : software.amazon.awssdk.services.dax.model.IsModifiable =
      software.amazon.awssdk.services.dax.model.IsModifiable.FALSE
  }
  case object CONDITIONAL extends zio.aws.dax.model.IsModifiable {
    override def unwrap
        : software.amazon.awssdk.services.dax.model.IsModifiable =
      software.amazon.awssdk.services.dax.model.IsModifiable.CONDITIONAL
  }
}
