package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsRequest(
    resourceName: String,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.ListTagsRequest = {
    import ListTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.ListTagsRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.ListTagsRequest.ReadOnly =
    zio.aws.dax.model.ListTagsRequest.wrap(buildAwsValue())
}
object ListTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.ListTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.ListTagsRequest = zio.aws.dax.model
      .ListTagsRequest(resourceName, nextToken.map(value => value))
    def resourceName: String
    def nextToken: Option[String]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.ListTagsRequest
  ) extends zio.aws.dax.model.ListTagsRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.ListTagsRequest
  ): zio.aws.dax.model.ListTagsRequest.ReadOnly = new Wrapper(impl)
}
