package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsResponse(
    tags: Option[Iterable[zio.aws.dax.model.Tag]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.ListTagsResponse = {
    import ListTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.ListTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.ListTagsResponse.ReadOnly =
    zio.aws.dax.model.ListTagsResponse.wrap(buildAwsValue())
}
object ListTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.ListTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.ListTagsResponse =
      zio.aws.dax.model.ListTagsResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tags: Option[List[zio.aws.dax.model.Tag.ReadOnly]]
    def nextToken: Option[String]
    def getTags: ZIO[Any, AwsError, List[zio.aws.dax.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.ListTagsResponse
  ) extends zio.aws.dax.model.ListTagsResponse.ReadOnly {
    override val tags: Option[List[zio.aws.dax.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.Tag.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.ListTagsResponse
  ): zio.aws.dax.model.ListTagsResponse.ReadOnly = new Wrapper(impl)
}
