package zio.aws.dax.model
import zio.aws.dax.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Node(
    nodeId: Option[String] = None,
    endpoint: Option[zio.aws.dax.model.Endpoint] = None,
    nodeCreateTime: Option[TStamp] = None,
    availabilityZone: Option[String] = None,
    nodeStatus: Option[String] = None,
    parameterGroupStatus: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dax.model.Node = {
    import Node.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.Node
      .builder()
      .optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        nodeCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeCreateTime)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(nodeStatus.map(value => value: java.lang.String))(
        _.nodeStatus
      )
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.Node.ReadOnly =
    zio.aws.dax.model.Node.wrap(buildAwsValue())
}
object Node {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dax.model.Node] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.Node = zio.aws.dax.model.Node(
      nodeId.map(value => value),
      endpoint.map(value => value.asEditable),
      nodeCreateTime.map(value => value),
      availabilityZone.map(value => value),
      nodeStatus.map(value => value),
      parameterGroupStatus.map(value => value)
    )
    def nodeId: Option[String]
    def endpoint: Option[zio.aws.dax.model.Endpoint.ReadOnly]
    def nodeCreateTime: Option[TStamp]
    def availabilityZone: Option[String]
    def nodeStatus: Option[String]
    def parameterGroupStatus: Option[String]
    def getNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeId", nodeId)
    def getEndpoint: ZIO[Any, AwsError, zio.aws.dax.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getNodeCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nodeCreateTime", nodeCreateTime)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getNodeStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeStatus", nodeStatus)
    def getParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupStatus", parameterGroupStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.Node
  ) extends zio.aws.dax.model.Node.ReadOnly {
    override val nodeId: Option[String] =
      scala.Option(impl.nodeId()).map(value => value: String)
    override val endpoint: Option[zio.aws.dax.model.Endpoint.ReadOnly] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.dax.model.Endpoint.wrap(value))
    override val nodeCreateTime: Option[TStamp] = scala
      .Option(impl.nodeCreateTime())
      .map(value => zio.aws.dax.model.primitives.TStamp(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val nodeStatus: Option[String] =
      scala.Option(impl.nodeStatus()).map(value => value: String)
    override val parameterGroupStatus: Option[String] =
      scala.Option(impl.parameterGroupStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.Node
  ): zio.aws.dax.model.Node.ReadOnly = new Wrapper(impl)
}
