package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NodeTypeSpecificValue(
    nodeType: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue = {
    import NodeTypeSpecificValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue
      .builder()
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.NodeTypeSpecificValue.ReadOnly =
    zio.aws.dax.model.NodeTypeSpecificValue.wrap(buildAwsValue())
}
object NodeTypeSpecificValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.NodeTypeSpecificValue =
      zio.aws.dax.model.NodeTypeSpecificValue(
        nodeType.map(value => value),
        value.map(value => value)
      )
    def nodeType: Option[String]
    def value: Option[String]
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue
  ) extends zio.aws.dax.model.NodeTypeSpecificValue.ReadOnly {
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue
  ): zio.aws.dax.model.NodeTypeSpecificValue.ReadOnly = new Wrapper(impl)
}
