package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NotificationConfiguration(
    topicArn: Option[String] = None,
    topicStatus: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.NotificationConfiguration
      .builder()
      .optionallyWith(topicArn.map(value => value: java.lang.String))(
        _.topicArn
      )
      .optionallyWith(topicStatus.map(value => value: java.lang.String))(
        _.topicStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.NotificationConfiguration.ReadOnly =
    zio.aws.dax.model.NotificationConfiguration.wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.NotificationConfiguration =
      zio.aws.dax.model.NotificationConfiguration(
        topicArn.map(value => value),
        topicStatus.map(value => value)
      )
    def topicArn: Option[String]
    def topicStatus: Option[String]
    def getTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicStatus", topicStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.NotificationConfiguration
  ) extends zio.aws.dax.model.NotificationConfiguration.ReadOnly {
    override val topicArn: Option[String] =
      scala.Option(impl.topicArn()).map(value => value: String)
    override val topicStatus: Option[String] =
      scala.Option(impl.topicStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.NotificationConfiguration
  ): zio.aws.dax.model.NotificationConfiguration.ReadOnly = new Wrapper(impl)
}
