package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Parameter(
    parameterName: Option[String] = None,
    parameterType: Option[zio.aws.dax.model.ParameterType] = None,
    parameterValue: Option[String] = None,
    nodeTypeSpecificValues: Option[
      Iterable[zio.aws.dax.model.NodeTypeSpecificValue]
    ] = None,
    description: Option[String] = None,
    source: Option[String] = None,
    dataType: Option[String] = None,
    allowedValues: Option[String] = None,
    isModifiable: Option[zio.aws.dax.model.IsModifiable] = None,
    changeType: Option[zio.aws.dax.model.ChangeType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dax.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.Parameter
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterType.map(value => value.unwrap))(_.parameterType)
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .optionallyWith(
        nodeTypeSpecificValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeTypeSpecificValues)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value.unwrap))(_.isModifiable)
      .optionallyWith(changeType.map(value => value.unwrap))(_.changeType)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.Parameter.ReadOnly =
    zio.aws.dax.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dax.model.Parameter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.Parameter = zio.aws.dax.model.Parameter(
      parameterName.map(value => value),
      parameterType.map(value => value),
      parameterValue.map(value => value),
      nodeTypeSpecificValues.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      description.map(value => value),
      source.map(value => value),
      dataType.map(value => value),
      allowedValues.map(value => value),
      isModifiable.map(value => value),
      changeType.map(value => value)
    )
    def parameterName: Option[String]
    def parameterType: Option[zio.aws.dax.model.ParameterType]
    def parameterValue: Option[String]
    def nodeTypeSpecificValues
        : Option[List[zio.aws.dax.model.NodeTypeSpecificValue.ReadOnly]]
    def description: Option[String]
    def source: Option[String]
    def dataType: Option[String]
    def allowedValues: Option[String]
    def isModifiable: Option[zio.aws.dax.model.IsModifiable]
    def changeType: Option[zio.aws.dax.model.ChangeType]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterType: ZIO[Any, AwsError, zio.aws.dax.model.ParameterType] =
      AwsError.unwrapOptionField("parameterType", parameterType)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
    def getNodeTypeSpecificValues: ZIO[Any, AwsError, List[
      zio.aws.dax.model.NodeTypeSpecificValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "nodeTypeSpecificValues",
      nodeTypeSpecificValues
    )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, zio.aws.dax.model.IsModifiable] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getChangeType: ZIO[Any, AwsError, zio.aws.dax.model.ChangeType] =
      AwsError.unwrapOptionField("changeType", changeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.Parameter
  ) extends zio.aws.dax.model.Parameter.ReadOnly {
    override val parameterName: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val parameterType: Option[zio.aws.dax.model.ParameterType] = scala
      .Option(impl.parameterType())
      .map(value => zio.aws.dax.model.ParameterType.wrap(value))
    override val parameterValue: Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
    override val nodeTypeSpecificValues
        : Option[List[zio.aws.dax.model.NodeTypeSpecificValue.ReadOnly]] = scala
      .Option(impl.nodeTypeSpecificValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.NodeTypeSpecificValue.wrap(item)
        }.toList
      )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val dataType: Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override val allowedValues: Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val isModifiable: Option[zio.aws.dax.model.IsModifiable] = scala
      .Option(impl.isModifiable())
      .map(value => zio.aws.dax.model.IsModifiable.wrap(value))
    override val changeType: Option[zio.aws.dax.model.ChangeType] = scala
      .Option(impl.changeType())
      .map(value => zio.aws.dax.model.ChangeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.Parameter
  ): zio.aws.dax.model.Parameter.ReadOnly = new Wrapper(impl)
}
