package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterGroup(
    parameterGroupName: Option[String] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.ParameterGroup = {
    import ParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.ParameterGroup
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.ParameterGroup.ReadOnly =
    zio.aws.dax.model.ParameterGroup.wrap(buildAwsValue())
}
object ParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.ParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.ParameterGroup =
      zio.aws.dax.model.ParameterGroup(
        parameterGroupName.map(value => value),
        description.map(value => value)
      )
    def parameterGroupName: Option[String]
    def description: Option[String]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.ParameterGroup
  ) extends zio.aws.dax.model.ParameterGroup.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.ParameterGroup
  ): zio.aws.dax.model.ParameterGroup.ReadOnly = new Wrapper(impl)
}
