package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterGroupStatus(
    parameterGroupName: Option[String] = None,
    parameterApplyStatus: Option[String] = None,
    nodeIdsToReboot: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.ParameterGroupStatus = {
    import ParameterGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.ParameterGroupStatus
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .optionallyWith(
        nodeIdsToReboot.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.nodeIdsToReboot)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.ParameterGroupStatus.ReadOnly =
    zio.aws.dax.model.ParameterGroupStatus.wrap(buildAwsValue())
}
object ParameterGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.ParameterGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.ParameterGroupStatus =
      zio.aws.dax.model.ParameterGroupStatus(
        parameterGroupName.map(value => value),
        parameterApplyStatus.map(value => value),
        nodeIdsToReboot.map(value => value)
      )
    def parameterGroupName: Option[String]
    def parameterApplyStatus: Option[String]
    def nodeIdsToReboot: Option[List[String]]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getNodeIdsToReboot: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("nodeIdsToReboot", nodeIdsToReboot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.ParameterGroupStatus
  ) extends zio.aws.dax.model.ParameterGroupStatus.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val parameterApplyStatus: Option[String] =
      scala.Option(impl.parameterApplyStatus()).map(value => value: String)
    override val nodeIdsToReboot: Option[List[String]] = scala
      .Option(impl.nodeIdsToReboot())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.ParameterGroupStatus
  ): zio.aws.dax.model.ParameterGroupStatus.ReadOnly = new Wrapper(impl)
}
