package zio.aws.dax.model
import scala.jdk.CollectionConverters.*
sealed trait ParameterType {
  def unwrap: software.amazon.awssdk.services.dax.model.ParameterType
}
object ParameterType {
  def wrap(
      value: software.amazon.awssdk.services.dax.model.ParameterType
  ): zio.aws.dax.model.ParameterType = value match {
    case software.amazon.awssdk.services.dax.model.ParameterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dax.model.ParameterType.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.dax.model.ParameterType.NODE_TYPE_SPECIFIC =>
      val r = NODE_TYPE_SPECIFIC
      r
  }
  case object unknownToSdkVersion extends zio.aws.dax.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.dax.model.ParameterType =
      software.amazon.awssdk.services.dax.model.ParameterType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.dax.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.dax.model.ParameterType =
      software.amazon.awssdk.services.dax.model.ParameterType.DEFAULT
  }
  case object NODE_TYPE_SPECIFIC extends zio.aws.dax.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.dax.model.ParameterType =
      software.amazon.awssdk.services.dax.model.ParameterType.NODE_TYPE_SPECIFIC
  }
}
