package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RebootNodeRequest(clusterName: String, nodeId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.RebootNodeRequest = {
    import RebootNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.RebootNodeRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodeId(nodeId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.RebootNodeRequest.ReadOnly =
    zio.aws.dax.model.RebootNodeRequest.wrap(buildAwsValue())
}
object RebootNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.RebootNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.RebootNodeRequest =
      zio.aws.dax.model.RebootNodeRequest(clusterName, nodeId)
    def clusterName: String
    def nodeId: String
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodeId: ZIO[Any, Nothing, String] = ZIO.succeed(nodeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.RebootNodeRequest
  ) extends zio.aws.dax.model.RebootNodeRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodeId: String = impl.nodeId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.RebootNodeRequest
  ): zio.aws.dax.model.RebootNodeRequest.ReadOnly = new Wrapper(impl)
}
