package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RebootNodeResponse(
    cluster: Option[zio.aws.dax.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.RebootNodeResponse = {
    import RebootNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.RebootNodeResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.RebootNodeResponse.ReadOnly =
    zio.aws.dax.model.RebootNodeResponse.wrap(buildAwsValue())
}
object RebootNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.RebootNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.RebootNodeResponse = zio.aws.dax.model
      .RebootNodeResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.dax.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.RebootNodeResponse
  ) extends zio.aws.dax.model.RebootNodeResponse.ReadOnly {
    override val cluster: Option[zio.aws.dax.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.dax.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.RebootNodeResponse
  ): zio.aws.dax.model.RebootNodeResponse.ReadOnly = new Wrapper(impl)
}
