package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SSEDescription(
    status: Option[zio.aws.dax.model.SSEStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.SSEDescription = {
    import SSEDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.SSEDescription
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.SSEDescription.ReadOnly =
    zio.aws.dax.model.SSEDescription.wrap(buildAwsValue())
}
object SSEDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.SSEDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.SSEDescription =
      zio.aws.dax.model.SSEDescription(status.map(value => value))
    def status: Option[zio.aws.dax.model.SSEStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.dax.model.SSEStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.SSEDescription
  ) extends zio.aws.dax.model.SSEDescription.ReadOnly {
    override val status: Option[zio.aws.dax.model.SSEStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.dax.model.SSEStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.SSEDescription
  ): zio.aws.dax.model.SSEDescription.ReadOnly = new Wrapper(impl)
}
