package zio.aws.dax.model
import zio.aws.dax.model.primitives.SSEEnabled
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SSESpecification(enabled: SSEEnabled) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.SSESpecification = {
    import SSESpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.SSESpecification
      .builder()
      .enabled(SSEEnabled.unwrap(enabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.SSESpecification.ReadOnly =
    zio.aws.dax.model.SSESpecification.wrap(buildAwsValue())
}
object SSESpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.SSESpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.SSESpecification =
      zio.aws.dax.model.SSESpecification(enabled)
    def enabled: SSEEnabled
    def getEnabled: ZIO[Any, Nothing, SSEEnabled] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.SSESpecification
  ) extends zio.aws.dax.model.SSESpecification.ReadOnly {
    override val enabled: SSEEnabled =
      zio.aws.dax.model.primitives.SSEEnabled(impl.enabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.SSESpecification
  ): zio.aws.dax.model.SSESpecification.ReadOnly = new Wrapper(impl)
}
